#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/spi.h"
#include "LCD.h"
#include "LCD.c"
#include "audio.h"
#include "audio.c"
#include "sounds.c"
#include "Arial_round_16x24.c"

#define LED_PIN PICO_DEFAULT_LED_PIN

int main()
{
    stdio_init_all();
    gpio_init(BLPIN);
    gpio_set_dir(BLPIN,GPIO_OUT);
    gpio_put(BLPIN,1);
	displaySetup();
	setbacklight(100);
    setrotation(1);  
    clear(BLACK);
	button red={2,280,88,35,"Red",0,1};//x,y,w,h,text,pressed,visible
	button green={98,280,88,35,"Green",0,1};//x,y,w,h,text,pressed,visible
	button blue={194,280,88,35,"Blue",0,1};//x,y,w,h,text,pressed,visible
	button erase={292,280,88,35,"Erase",0,1};//x,y,w,h,text,pressed,visible
	button light={390,280,88,35,"Light",0,1};//x,y,w,h,text,pressed,visible
	showarray(168,10,"Draw Demo",Arial_round_16x24,YELLOW,BLACK);
	drawbutton(&red);
	drawbutton(&green);
	drawbutton(&blue);
	drawbutton(&erase);
	drawbutton(&light);
	unsigned int draw=WHITE;
    int lastx=-1;
	int lasty=-1;
	int b=100;
	audioInit();
	audioSetRate(8000);
	while (true) {
	  int x,y,p;
	  x=touchx();
	  y=touchy();
	  if((x>-1)&&(y>-1)&&(lastx>-1)&&(lasty>-1)){
		line(lastx,lasty,x,y,draw);
	  }
	  lastx=x;
	  lasty=y;
	  checkpress(&red);
	  if(red.lastchange==BUTTON_DOWN){draw=RED;}  //set draw colour on button down
	  if(red.lastchange){drawbutton(&red);}        //redraw on change
	  checkpress(&green);
	  if(green.lastchange==BUTTON_DOWN){draw=GREEN;}
	  if(green.lastchange){drawbutton(&green);}
	  checkpress(&blue);
	  if(blue.lastchange==BUTTON_DOWN){draw=BLUE;}
	  if(blue.lastchange){drawbutton(&blue);}
	  checkpress(&light);
	  if(light.lastchange==BUTTON_DOWN){b=b+10;}  //change backlight
	  if(light.lastchange){drawbutton(&light);}        //redraw on change
	  checkpress(&erase);
	  if(erase.lastchange==BUTTON_UP){drawbutton(&erase);clear(BLACK);}
	  if(erase.lastchange){     //redraw all on screen erase
		drawbutton(&red);
		drawbutton(&green);
		drawbutton(&blue);
		drawbutton(&erase);
		drawbutton(&light);
	  }
	  if(b>100){b=10;}
	  setbacklight(b);
	  if((erase.lastchange==BUTTON_DOWN)||(red.lastchange==BUTTON_DOWN)||(green.lastchange==BUTTON_DOWN)||(blue.lastchange==BUTTON_DOWN)||(light.lastchange==BUTTON_DOWN)){
		if(audioSpace()){
		  audioQueue(boop,sizeof(boop));
		  audioPlay(AUDIO_PLAY_MONO);
		}
	  }
	  if((erase.lastchange==BUTTON_UP)||(red.lastchange==BUTTON_UP)||(green.lastchange==BUTTON_UP)||(blue.lastchange==BUTTON_UP)||(light.lastchange==BUTTON_UP)){
		if(audioSpace()){
		  audioQueue(beep,sizeof(beep));
		  audioPlay(AUDIO_PLAY_MONO);
		}
	  }
    }
    return 0;
}
